/*
 * Decompiled with CFR 0.152.
 */
package eng1.model.views;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.eng1.game.HeslingtonHustle;

public class PreferencesScreen
implements Screen {
    private HeslingtonHustle parent;
    private Stage stage;
    private Label titleLabel;
    private Label volumeMusicLabel;
    private Label volumeSoundLabel;
    private Label musicOnOffLabel;
    private Label soundOnOffLabel;

    public PreferencesScreen(HeslingtonHustle eng1) {
        this.parent = eng1;
        this.stage = new Stage(new ScreenViewport());
    }

    @Override
    public void show() {
        this.stage.clear();
        Gdx.input.setInputProcessor(this.stage);
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Skin skin = new Skin(Gdx.files.internal("skin/uiskin.json"));
        final Slider volumeMusicSlider = new Slider(0.0f, 1.0f, 0.1f, false, skin);
        volumeMusicSlider.setValue(this.parent.getPreferences().getMusicVolume());
        volumeMusicSlider.addListener(new EventListener(){

            @Override
            public boolean handle(Event event) {
                PreferencesScreen.this.parent.getPreferences().setMusicVolume(volumeMusicSlider.getValue());
                return false;
            }
        });
        final Slider soundMusicSlider = new Slider(0.0f, 1.0f, 0.1f, false, skin);
        soundMusicSlider.setValue(this.parent.getPreferences().getSoundVolume());
        soundMusicSlider.addListener(new EventListener(){

            @Override
            public boolean handle(Event event) {
                PreferencesScreen.this.parent.getPreferences().setSoundVolume(soundMusicSlider.getValue());
                return false;
            }
        });
        final CheckBox musicCheckbox = new CheckBox(null, skin);
        musicCheckbox.setChecked(this.parent.getPreferences().isMusicEnabled());
        musicCheckbox.addListener(new EventListener(){

            @Override
            public boolean handle(Event event) {
                boolean enabled = musicCheckbox.isChecked();
                PreferencesScreen.this.parent.getPreferences().setMusicEnabled(enabled);
                return false;
            }
        });
        final CheckBox soundEffectsCheckbox = new CheckBox(null, skin);
        soundEffectsCheckbox.setChecked(this.parent.getPreferences().isSoundEffectsEnabled());
        soundEffectsCheckbox.addListener(new EventListener(){

            @Override
            public boolean handle(Event event) {
                boolean enabled = soundEffectsCheckbox.isChecked();
                PreferencesScreen.this.parent.getPreferences().setSoundEffectsEnabled(enabled);
                return false;
            }
        });
        TextButton backButton = new TextButton("Back", skin);
        backButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PreferencesScreen.this.parent.changeScreen(0);
            }
        });
        TextButton quitButton = new TextButton("Quit", skin);
        quitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        });
        this.titleLabel = new Label((CharSequence)"Preferences", skin);
        this.volumeMusicLabel = new Label((CharSequence)"Music Volume", skin);
        this.volumeSoundLabel = new Label((CharSequence)"Sound Volume", skin);
        this.musicOnOffLabel = new Label((CharSequence)"Music", skin);
        this.soundOnOffLabel = new Label((CharSequence)"Sound Effect", skin);
        table.add(this.titleLabel).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(this.volumeMusicLabel).left();
        table.add(volumeMusicSlider);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(this.musicOnOffLabel).left();
        table.add(musicCheckbox);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(this.volumeSoundLabel).left();
        table.add(soundMusicSlider);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(this.soundOnOffLabel).left();
        table.add(soundEffectsCheckbox);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(backButton).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(quitButton).colspan(50);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

