/*
 * Decompiled with CFR 0.152.
 */
package eng1.model.views;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.eng1.game.Activity;
import com.eng1.game.HeslingtonHustle;
import java.util.Map;

public class EndScreen
implements Screen {
    private HeslingtonHustle parent;
    private Stage stage;
    private Label titleLabel;
    private Label scoreLabel;
    private static Map<String, Map<String, Activity>> activities;

    public EndScreen(HeslingtonHustle eng1) {
        this.parent = eng1;
        this.stage = new Stage(new ScreenViewport());
    }

    @Override
    public void show() {
        this.stage.clear();
        Gdx.input.setInputProcessor(this.stage);
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Skin skin = new Skin(Gdx.files.internal("skin/uiskin.json"));
        this.titleLabel = new Label((CharSequence)"Heslington Hustle", skin);
        this.scoreLabel = new Label((CharSequence)("Score: " + Activity.getFinalScore()), skin);
        table.add(this.titleLabel).colspan(2);
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        Map<String, Integer> completedActivities = Activity.countCompletedActivities();
        for (String type : completedActivities.keySet()) {
            table.add(new Label((CharSequence)(type + ": " + completedActivities.get(type)), skin)).left().pad(10.0f);
            table.row();
        }
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(this.scoreLabel).row();
        TextButton quitButton = new TextButton("Quit", skin);
        quitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        });
        table.row().pad(10.0f, 0.0f, 0.0f, 10.0f);
        table.add(quitButton).colspan(50);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

