/*
 * Decompiled with CFR 0.152.
 */
package eng1.model.views;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.eng1.game.HeslingtonHustle;
import com.eng1.game.Play;

public class CharacterScreen
extends ScreenAdapter {
    private HeslingtonHustle parent;
    private Stage stage;
    private Label titleLabel;

    public CharacterScreen(HeslingtonHustle game) {
        this.parent = game;
        this.stage = new Stage(new StretchViewport(800.0f, 600.0f));
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void show() {
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Skin skin = new Skin(Gdx.files.internal("skin/uiskin.json"));
        this.titleLabel = new Label((CharSequence)"Character Selection", skin);
        TextButton character1Button = new TextButton("Character 1", skin);
        character1Button.setSize(1000.0f, 50.0f);
        TextButton character2Button = new TextButton("Character 2", skin);
        character2Button.setSize(200.0f, 50.0f);
        TextButton character3Button = new TextButton("Character 3", skin);
        character3Button.setSize(200.0f, 50.0f);
        Texture character1Texture = new Texture(Gdx.files.internal("playerCharacters/playerCharacter1.png"));
        Texture character2Texture = new Texture(Gdx.files.internal("playerCharacters/playerCharacter2.png"));
        Texture character3Texture = new Texture(Gdx.files.internal("playerCharacters/playerCharacter3.png"));
        Image character1Image = new Image(new TextureRegionDrawable(new TextureRegion(character1Texture)));
        character1Image.setSize(200.0f, 200.0f);
        Image character2Image = new Image(new TextureRegionDrawable(new TextureRegion(character2Texture)));
        character2Image.setSize(200.0f, 200.0f);
        Image character3Image = new Image(new TextureRegionDrawable(new TextureRegion(character3Texture)));
        character3Image.setSize(200.0f, 200.0f);
        character1Button.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Play.setSelectedCharacter("Character1");
                CharacterScreen.this.parent.changeScreen(2);
            }
        });
        character2Button.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Play.setSelectedCharacter("Character2");
                CharacterScreen.this.parent.changeScreen(2);
            }
        });
        character3Button.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Play.setSelectedCharacter("Character3");
                CharacterScreen.this.parent.changeScreen(2);
            }
        });
        table.pad(20.0f);
        table.defaults().pad(10.0f);
        table.add(this.titleLabel).colspan(3).padBottom(40.0f);
        table.row();
        table.add(character1Button).fillX().uniformX().padRight(20.0f);
        table.add(character2Button).fillX().uniformX().padRight(20.0f);
        table.add(character3Button).fillX().uniformX();
        table.row().padTop(40.0f);
        table.add(character1Image).center().padRight(20.0f);
        table.add(character2Image).center().padRight(20.0f);
        table.add(character3Image).center();
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }
}

