/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Vector2;
import com.eng1.game.Activity;
import com.eng1.game.Play;

public class Player
extends Sprite
implements InputProcessor {
    private Vector2 velocity = new Vector2();
    private float speed = 300.0f;
    private float animationTime = 0.0f;
    private Animation still;
    private Animation left;
    private Animation right;
    private TiledMapTileLayer collisionLayer;
    private String blockedKey = "blocked";
    private String transitionKey = "transition";
    public static String transitionValue = "";
    private String activityKey = "activity";
    public static String activityValue = "";

    public Player(Sprite sprite, TiledMapTileLayer collisionLayer) {
        super(sprite);
        this.collisionLayer = collisionLayer;
        this.setScale(3.0f);
    }

    @Override
    public void draw(Batch batch) {
        this.update(Gdx.graphics.getDeltaTime());
        super.draw(batch);
    }

    public void update(float delta) {
        float oldX = this.getX();
        float oldY = this.getY();
        boolean collisionX = false;
        boolean collisionY = false;
        boolean transition = false;
        boolean activity = false;
        this.setX(this.getX() + this.velocity.x * delta);
        if (this.velocity.x < 0.0f) {
            collisionX = this.collidesLeft();
            transition = this.transitionLeft();
            activity = this.activityLeft();
        } else if (this.velocity.x > 0.0f) {
            collisionX = this.collidesRight();
            transition = this.transitionRight();
            activity = this.activityRight();
        }
        if (collisionX) {
            this.setX(oldX);
            this.velocity.x = 0.0f;
        } else if (transition) {
            this.velocity.x = 0.0f;
            Play.changeMap(transitionValue);
            this.setX(oldX);
            transition = false;
        } else if (activity) {
            this.velocity.x = 0.0f;
            Activity.completeActivity(activityValue);
            this.setX(oldX);
        }
        this.setY(this.getY() + this.velocity.y * delta);
        if (this.velocity.y < 0.0f) {
            collisionY = this.collidesBottom();
            transition = this.transitionBottom();
            activity = this.activityBottom();
        } else if (this.velocity.y > 0.0f) {
            collisionY = this.collidesTop();
            transition = this.transitionTop();
            activity = this.activityTop();
        }
        if (collisionY) {
            this.setY(oldY);
            this.velocity.y = 0.0f;
        } else if (transition) {
            this.velocity.y = 0.0f;
            Play.changeMap(transitionValue);
            this.setY(oldY);
            transition = false;
        } else if (activity) {
            this.velocity.y = 0.0f;
            Activity.completeActivity(activityValue);
            this.setY(oldY);
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 19: 
            case 51: {
                this.velocity.y = this.speed;
                break;
            }
            case 21: 
            case 29: {
                this.velocity.x = -this.speed;
                break;
            }
            case 20: 
            case 47: {
                this.velocity.y = -this.speed;
                break;
            }
            case 22: 
            case 32: {
                this.velocity.x = this.speed;
            }
        }
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 19: 
            case 20: 
            case 47: 
            case 51: {
                this.velocity.y = 0.0f;
                break;
            }
            case 21: 
            case 22: 
            case 29: 
            case 32: {
                this.velocity.x = 0.0f;
            }
        }
        return true;
    }

    private boolean isCellBlocked(float x, float y) {
        TiledMapTileLayer.Cell cell = this.collisionLayer.getCell((int)(x / (float)this.collisionLayer.getTileWidth()), (int)(y / (float)this.collisionLayer.getTileHeight()));
        return cell != null && cell.getTile() != null && cell.getTile().getProperties().containsKey(this.blockedKey);
    }

    private boolean isCellTransition(float x, float y) {
        TiledMapTileLayer.Cell cell = this.collisionLayer.getCell((int)(x / (float)this.collisionLayer.getTileWidth()), (int)(y / (float)this.collisionLayer.getTileHeight()));
        return cell != null && cell.getTile() != null && cell.getTile().getProperties().containsKey(this.transitionKey);
    }

    public boolean isCellActivity(float x, float y) {
        TiledMapTileLayer.Cell cell = this.collisionLayer.getCell((int)(x / (float)this.collisionLayer.getTileWidth()), (int)(y / (float)this.collisionLayer.getTileHeight()));
        return cell != null && cell.getTile() != null && cell.getTile().getProperties().containsKey(this.activityKey);
    }

    private void getTransition(float x, float y) {
        Object value;
        TiledMapTileLayer.Cell cell = this.collisionLayer.getCell((int)(x / (float)this.collisionLayer.getTileWidth()), (int)(y / (float)this.collisionLayer.getTileHeight()));
        if (cell.getTile().getProperties().containsKey(this.transitionKey) && (value = cell.getTile().getProperties().get("transition")) != null) {
            transitionValue = value.toString();
        }
    }

    private void getActivity(float x, float y) {
        Object value;
        TiledMapTileLayer.Cell cell = this.collisionLayer.getCell((int)(x / (float)this.collisionLayer.getTileWidth()), (int)(y / (float)this.collisionLayer.getTileHeight()));
        if (cell.getTile().getProperties().containsKey(this.activityKey) && (value = cell.getTile().getProperties().get("activity")) != null) {
            activityValue = value.toString();
        }
    }

    public boolean collidesRight() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight() && !(collides = this.isCellBlocked(this.getX() + this.getWidth(), this.getY() + step)); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
        }
        return collides;
    }

    public boolean transitionRight() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellTransition(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getTransition(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean activityRight() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellActivity(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getActivity(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean collidesLeft() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight() && !(collides = this.isCellBlocked(this.getX() + this.getWidth(), this.getY() + step)); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
        }
        return collides;
    }

    public boolean transitionLeft() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellTransition(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getTransition(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean activityLeft() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellActivity(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getActivity(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean collidesTop() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getWidth() && !(collides = this.isCellBlocked(this.getX() + this.getWidth(), this.getY() + step)); step += (float)(this.collisionLayer.getTileWidth() / 2)) {
        }
        return collides;
    }

    public boolean transitionTop() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellTransition(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getTransition(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean activityTop() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellActivity(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getActivity(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean collidesBottom() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getWidth() && !(collides = this.isCellBlocked(this.getX() + this.getWidth(), this.getY() + step)); step += (float)(this.collisionLayer.getTileWidth() / 2)) {
        }
        return collides;
    }

    public boolean transitionBottom() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellTransition(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getTransition(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public boolean activityBottom() {
        boolean collides = false;
        for (float step = 0.0f; step < this.getHeight(); step += (float)(this.collisionLayer.getTileHeight() / 2)) {
            collides = this.isCellActivity(this.getX() + this.getWidth(), this.getY() + step);
            if (!collides) continue;
            this.getActivity(this.getX() + this.getWidth(), this.getY() + step);
            break;
        }
        return collides;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector2 velocity) {
        this.velocity = velocity;
    }

    public TiledMapTileLayer getCollisionLayer() {
        return this.collisionLayer;
    }

    public void setCollisionLayer(TiledMapTileLayer collisionLayer) {
        this.collisionLayer = collisionLayer;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        return false;
    }
}

