/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.eng1.game.Activity;
import com.eng1.game.GameStats;
import com.eng1.game.Player;
import java.util.Arrays;
import java.util.List;

public class Play
implements Screen {
    private static OrthogonalTiledMapRenderer renderer;
    private static OrthographicCamera camera;
    private static AssetManager assetManager;
    private TextureAtlas playerAtlas;
    private static Player player;
    private static TiledMap currentMap;
    private static TiledMap oldMap;
    private static String currentMapPath;
    private static String oldMapPath;
    private static final List<String> scaledMaps;
    private static final List<String> largeScaledMaps;
    private static String selectedCharacter;
    BitmapFont displayDateTime = new BitmapFont();

    public Play() {
        Activity.createActivities();
        camera = new OrthographicCamera();
    }

    private void loadMap(String path) {
        assetManager.setLoader(TiledMap.class, new TmxMapLoader(new InternalFileHandleResolver()));
        assetManager.load(path, TiledMap.class);
        assetManager.finishLoading();
        currentMapPath = path;
        currentMap = assetManager.get(currentMapPath, TiledMap.class);
        Play.setPlayerPosition();
    }

    static void changeMap(String path) {
        currentMap.dispose();
        oldMap = currentMap;
        oldMapPath = currentMapPath;
        currentMapPath = path;
        assetManager.load(path, TiledMap.class);
        assetManager.finishLoading();
        currentMap = assetManager.get(path, TiledMap.class);
        renderer.setMap(currentMap);
        Play.setPlayerPosition();
        Play.camera.zoom = scaledMaps.contains(currentMapPath) ? 0.35f : (largeScaledMaps.contains(currentMapPath) ? 0.5f : 1.0f);
        Play.camera.position.set(Play.camera.viewportWidth / 2.0f, Play.camera.viewportHeight / 2.0f, 0.0f);
        camera.update();
    }

    public static void setSelectedCharacter(String character) {
        selectedCharacter = character;
    }

    private static void setPlayerPosition() {
        if (selectedCharacter.equals("Character1")) {
            player = new Player(new Sprite(new Texture("playerCharacters/playerCharacter1.png")), (TiledMapTileLayer)currentMap.getLayers().get(0));
        } else if (selectedCharacter.equals("Character2")) {
            player = new Player(new Sprite(new Texture("playerCharacters/playerCharacter2.png")), (TiledMapTileLayer)currentMap.getLayers().get(0));
        } else if (selectedCharacter.equals("Character3")) {
            player = new Player(new Sprite(new Texture("playerCharacters/playerCharacter3.png")), (TiledMapTileLayer)currentMap.getLayers().get(0));
        }
        switch (currentMapPath) {
            case "maps/map1/map1.tmx": {
                switch (oldMapPath) {
                    case "maps/map2/map2.tmx": {
                        player.setPosition(115 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map3/map3.tmx": {
                        player.setPosition(5 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map4/map4.tmx": {
                        player.setPosition(67 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 5) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map8/home.tmx": {
                        player.setPosition(105 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 53) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map2/map2.tmx": {
                switch (oldMapPath) {
                    case "maps/map1/map1.tmx": {
                        player.setPosition(5 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map9/gym.tmx": {
                        player.setPosition(105 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map3/map3.tmx": {
                switch (oldMapPath) {
                    case "maps/map1/map1.tmx": {
                        player.setPosition(115 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map5/map5.tmx": {
                        player.setPosition(62 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 5) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map6/map6.tmx": {
                        player.setPosition(5 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map11/piazza.tmx": {
                        player.setPosition(30 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 54) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map4/map4.tmx": {
                switch (oldMapPath) {
                    case "maps/map1/map1.tmx": {
                        player.setPosition(67 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 64) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map5/map5.tmx": {
                switch (oldMapPath) {
                    case "maps/map3/map3.tmx": {
                        player.setPosition(62 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 66) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map10/computer-science-building.tmx": {
                        player.setPosition(45 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 65) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map6/map6.tmx": {
                switch (oldMapPath) {
                    case "maps/map3/map3.tmx": {
                        player.setPosition(116 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                        break;
                    }
                    case "maps/map7/map7.tmx": {
                        player.setPosition(5 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map7/map7.tmx": {
                switch (oldMapPath) {
                    case "maps/map6/map6.tmx": {
                        player.setPosition(116 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 57) * player.getCollisionLayer().getTileHeight());
                    }
                }
                break;
            }
            case "maps/map8/home.tmx": {
                switch (oldMapPath) {
                    case "": 
                    case "maps/map1/map1.tmx": {
                        player.setPosition(56 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 40) * player.getCollisionLayer().getTileHeight());
                        player.setScale(1.0f);
                        player.setSpeed(102.0f);
                    }
                }
                break;
            }
            case "maps/map9/gym.tmx": {
                switch (oldMapPath) {
                    case "maps/map2/map2.tmx": {
                        player.setPosition(60 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 41) * player.getCollisionLayer().getTileHeight());
                        player.setScale(1.0f);
                        player.setSpeed(102.0f);
                    }
                }
                break;
            }
            case "maps/map10/computer-science-building.tmx": {
                switch (oldMapPath) {
                    case "maps/map5/map5.tmx": {
                        player.setPosition(60 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 45) * player.getCollisionLayer().getTileHeight());
                        player.setScale(1.0f);
                        player.setSpeed(102.0f);
                    }
                }
                break;
            }
            case "maps/map11/piazza.tmx": {
                switch (oldMapPath) {
                    case "maps/map3/map3.tmx": {
                        player.setPosition(58 * player.getCollisionLayer().getTileWidth(), (player.getCollisionLayer().getHeight() - 48) * player.getCollisionLayer().getTileHeight());
                        player.setScale(1.0f);
                        player.setSpeed(102.0f);
                    }
                }
            }
        }
        Gdx.input.setInputProcessor(player);
    }

    @Override
    public void show() {
        this.loadMap(currentMapPath);
        camera = new OrthographicCamera();
        renderer = new OrthogonalTiledMapRenderer(currentMap);
    }

    @Override
    public void render(float delta) {
        Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl20.glClear(16640);
        renderer.setView(camera);
        renderer.render();
        renderer.getBatch().begin();
        if (scaledMaps.contains(currentMapPath)) {
            this.displayDateTime.getData().setScale(1.0f);
            this.displayDateTime.draw(renderer.getBatch(), "Day: " + GameStats.getDay() + " Time: " + GameStats.getTime() + " Energy: " + GameStats.getEnergy(), 630.0f, 725.0f);
        } else if (largeScaledMaps.contains(currentMapPath)) {
            this.displayDateTime.getData().setScale(1.0f);
            this.displayDateTime.draw(renderer.getBatch(), "Day: " + GameStats.getDay() + " Time: " + GameStats.getTime() + " Energy: " + GameStats.getEnergy(), 530.0f, 780.0f);
        } else {
            this.displayDateTime.getData().setScale(2.0f);
            this.displayDateTime.draw(renderer.getBatch(), "Day: " + GameStats.getDay() + " Time: " + GameStats.getTime() + " Energy: " + GameStats.getEnergy(), 12.0f, 1070.0f);
        }
        player.draw(renderer.getBatch());
        renderer.getBatch().end();
    }

    @Override
    public void resize(int width, int height) {
        Play.camera.viewportWidth = width;
        Play.camera.viewportHeight = height;
        Play.camera.zoom = scaledMaps.contains(currentMapPath) ? 0.35f : (largeScaledMaps.contains(currentMapPath) ? 0.5f : 1.0f);
        Play.camera.position.set(Play.camera.viewportWidth / 2.0f, Play.camera.viewportHeight / 2.0f, 0.0f);
        camera.update();
        renderer.getBatch().setProjectionMatrix(Play.camera.combined);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    static {
        assetManager = new AssetManager();
        currentMapPath = "maps/map8/home.tmx";
        oldMapPath = "";
        scaledMaps = Arrays.asList("maps/map8/home.tmx", "maps/map9/gym.tmx");
        largeScaledMaps = Arrays.asList("maps/map10/computer-science-building.tmx", "maps/map11/piazza.tmx");
    }
}

