/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;

public class AppPreferences {
    private static final String PREF_MUSIC_VOLUME = "volume";
    private static final String PREF_MUSIC_ENABLED = "music.enabled";
    private static final String PREF_SOUND_ENABLED = "sound.enabled";
    private static final String PREF_SOUND_VOL = "sound";
    private static final String PREFS_NAME = "HeslingtonHustle";

    protected Preferences getPrefs() {
        return Gdx.app.getPreferences(PREFS_NAME);
    }

    public boolean isSoundEffectsEnabled() {
        return this.getPrefs().getBoolean(PREF_SOUND_ENABLED, true);
    }

    public void setSoundEffectsEnabled(boolean soundEffectsEnabled) {
        this.getPrefs().putBoolean(PREF_SOUND_ENABLED, soundEffectsEnabled);
        this.getPrefs().flush();
    }

    public boolean isMusicEnabled() {
        return this.getPrefs().getBoolean(PREF_MUSIC_ENABLED, true);
    }

    public void setMusicEnabled(boolean musicEnabled) {
        this.getPrefs().putBoolean(PREF_MUSIC_ENABLED, musicEnabled);
        this.getPrefs().flush();
    }

    public float getMusicVolume() {
        return this.getPrefs().getFloat(PREF_MUSIC_VOLUME, 0.5f);
    }

    public void setMusicVolume(float volume) {
        this.getPrefs().putFloat(PREF_MUSIC_VOLUME, volume);
        this.getPrefs().flush();
    }

    public float getSoundVolume() {
        return this.getPrefs().getFloat(PREF_SOUND_VOL, 0.5f);
    }

    public void setSoundVolume(float volume) {
        this.getPrefs().putFloat(PREF_SOUND_VOL, volume);
        this.getPrefs().flush();
    }
}

