/*
 * Decompiled with CFR 0.152.
 */
package com.eng1.game;

import com.eng1.game.GameStats;
import com.eng1.game.HeslingtonHustle;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class Activity {
    private static Map<String, Map<String, Activity>> activities;
    private final LocalTime timeNeeded;
    private final int energyNeeded;
    private int timesCompletedWeek;
    private int timesCompletedDay;
    private final int reward;
    private static HeslingtonHustle gameInstance;
    private static int finalScore;

    public Activity(LocalTime timeNeeded, int energyNeeded, int reward) {
        this.timeNeeded = timeNeeded;
        this.energyNeeded = energyNeeded;
        this.timesCompletedWeek = 0;
        this.timesCompletedDay = 0;
        this.reward = reward;
    }

    public static void setGameInstance(HeslingtonHustle game) {
        gameInstance = game;
    }

    public static void createActivities() {
        activities = new HashMap<String, Map<String, Activity>>();
        activities.put("Study", new HashMap());
        activities.put("Relax", new HashMap());
        activities.put("Eat", new HashMap());
        activities.put("Sleep", new HashMap());
        activities.get("Study").put("CompSci", new Activity(LocalTime.of(3, 0), 30, 0));
        activities.get("Relax").put("Gym", new Activity(LocalTime.of(1, 0), 20, 0));
        activities.get("Eat").put("Piazza", new Activity(LocalTime.of(1, 0), 10, 0));
        activities.get("Sleep").put("Home", new Activity(LocalTime.of(0, 0), 0, 0));
    }

    public static void completeActivity(String activityIdentifier) {
        String[] activityLocator = activityIdentifier.split(",");
        String type = activityLocator[0];
        String location = activityLocator[1];
        System.out.println(type);
        System.out.println(location);
        activities.get(type).get(location).complete();
        if (type.equals("Sleep")) {
            Activity.sleep();
        }
    }

    public String complete() {
        LocalTime tempTime = GameStats.getTime().plusHours(this.timeNeeded.getHour());
        if ((tempTime = tempTime.plusMinutes(this.timeNeeded.getMinute())).isAfter(GameStats.DAY_END) && tempTime.isBefore(GameStats.DAY_START)) {
            return "Insufficient Time";
        }
        if (GameStats.getEnergy() - this.energyNeeded < 0) {
            return "Insufficient Energy";
        }
        ++this.timesCompletedDay;
        ++this.timesCompletedWeek;
        GameStats.increaseTime(this.timeNeeded);
        GameStats.decreaseEnergy(this.energyNeeded);
        System.out.println("Current time: " + GameStats.getTime());
        System.out.println("Current energy: " + GameStats.getEnergy());
        System.out.println("Current score: " + GameStats.getScore());
        return "Activity Completed";
    }

    public static void sleep() {
        System.out.println("Sleeping");
        GameStats.increaseScore(Activity.calculateDayScore());
        for (Map<String, Activity> typeActivities : activities.values()) {
            for (Activity activity : typeActivities.values()) {
                activity.timesCompletedDay = 0;
            }
        }
        GameStats.newDay();
        System.out.println(Activity.countCompletedActivities());
        if (GameStats.getDay() > 7) {
            Map<String, Integer> activitiesCompleted = Activity.countCompletedActivities();
            int score = Activity.calculateDayScore();
            gameInstance.changeScreen(3);
        }
    }

    public static Map<String, Integer> countCompletedActivities() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("Study", 0);
        counts.put("Relax", 0);
        counts.put("Eat", 0);
        counts.put("Sleep", 0);
        for (String type : activities.keySet()) {
            for (Activity activity : activities.get(type).values()) {
                counts.put(type, (Integer)counts.get(type) + activity.timesCompletedWeek);
            }
        }
        return counts;
    }

    public static int calculateDayScore() {
        return 0;
    }

    public static int getFinalScore() {
        return finalScore;
    }

    public static void setFinalScore(int score) {
        finalScore = score;
    }
}

